<script src="<?php echo plugins_url('../js/lbg_settings_page.js', __FILE__); ?>" type="text/javascript"></script>


<div class="wrap">
	<div id="lbg_logo">
			<h2><?php esc_html_e( 'Player Settings for player:' , 'audio6-html5' );?> <span class="lbg_the_redb"><?php echo esc_html($_SESSION['xname'])?> - <?php esc_html_e( 'ID' , 'audio6-html5' );?> #<?php echo esc_html($_SESSION['xid'])?></span></h2>
 	</div>

	<div class="lbg_magnifier"><img src="<?php echo plugins_url('images/icons/magnifier.png', dirname(__FILE__))?>" alt="add" align="absmiddle" /> <a href="javascript: void(0);" onclick="showDialogPreview(<?php echo strip_tags($_SESSION['xid'])?>)"><?php esc_html_e( 'Preview Player' , 'audio6-html5' );?></a></div>

	<div id="previewDialog"><iframe id="previewDialogIframe" src="" width="100%" height="600" class="lbg_b0"></iframe></div>

  <form method="POST" enctype="multipart/form-data" id="form-player-settings">
	<script>
	jQuery(function() {
		var icons = {
			header: "ui-icon-circle-arrow-e",
			headerSelected: "ui-icon-circle-arrow-s"
		};
		jQuery( "#accordion" ).accordion({
			icons: icons,
			autoHeight: false
		});
	});
	</script>


<div id="accordion">
  <h3><a href="#">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<?php esc_html_e( 'General Settings' , 'audio6-html5' );?></a></h3>
  <div class="lbg_pd30">
	  <table class="wp-list-table widefat fixed pages" cellspacing="0">

		  <tr>
		    <td align="right" valign="top" class="row-title" width="35%"><?php esc_html_e( 'Player Name' , 'audio6-html5' );?></td>
		    <td align="left" valign="top" width="65%"><input name="name" type="text" size="40" id="name" value="<?php echo esc_attr($_SESSION['xname']);?>"/></td>
	      </tr>
		  <tr>
		    <td align="right" valign="top" class="row-title"><?php esc_html_e( 'Radio Stream Link' , 'audio6-html5' );?></td>
		    <td align="left" valign="middle"><input name="radio_stream" type="text" size="60" id="radio_stream" value="<?php echo esc_attr($_POST['radio_stream']);?>"/></td>
	      </tr>
		  <tr>
		    <td align="right" valign="top" class="row-title">&nbsp;</td>
		    <td align="left" valign="top"><span class="small_text"><u><?php esc_html_e( 'Shoutcast link structure:' , 'audio6-html5' );?></u> http://[ip]:[port]/;<br />
	        <u><?php esc_html_e( 'Icecast link structure:' , 'audio6-html5' );?></u> http://[domain]:[port]/mountpoint</span></td>
	    </tr>
			<tr>
				<td align="right" valign="top" class="row-title"><?php esc_html_e( 'Radio Name' , 'audio6-html5' );?></td>
				<td align="left" valign="middle"><input name="radio_name" type="text" size="60" id="radio_name" value="<?php echo esc_attr($_POST['radio_name']);?>"/></td>
			</tr>
			<tr>
				<td align="right" valign="top" colspan="2"><hr></hr></td>
			</tr>
			<tr>
			    <td align="right" valign="top" class="row-title"><?php esc_html_e( 'AzuraCast nowplaying API Url' , 'audio6-html5' );?></td>
			    <td align="left" valign="middle"><input name="azuracast_api_nowplaying_url" type="text" size="60" id="azuracast_api_nowplaying_url" value="<?php echo esc_attr($_POST['azuracast_api_nowplaying_url']);?>"/></td>
		  </tr>
			<tr>
				<td align="right" valign="top" class="row-title"><?php esc_html_e( 'Grab Artist Photo From AzuraCast API' , 'audio6-html5' );?></td>
				<td align="left" valign="middle"><select name="azuracast_get_image" id="azuracast_get_image">
							<option value="true" <?php echo (($_POST['azuracast_get_image']=='true')?'selected="selected"':'')?>>true</option>
							<option value="false" <?php echo (($_POST['azuracast_get_image']=='false')?'selected="selected"':'')?>>false</option>
						</select></td>
			</tr>
			<tr>
				    <td align="right" valign="top" class="row-title">&nbsp;</td>
				    <td align="left" valign="top"><span class="small_text"><strong><?php esc_html_e( 'ONLY' , 'audio6-html5' );?></strong><i> <?php esc_html_e( "if you'll use an AzuraCast radio stream link." , "audio6-html5" );?> <br><?php esc_html_e( 'Example' , 'audio6-html5' );?>: https://YOUR_RADIO_DOMAIN.com/api/nowplaying/YOUR_RADIO_SHORTCODE</i></td>
			</tr>
			<tr>
				<td align="right" valign="top" colspan="2"><hr></hr></td>
			</tr>
			<tr>
			    <td align="right" valign="top" class="row-title"><?php esc_html_e( 'Url custom metadata file ( OPTIONAL )' , 'audio6-html5' );?></td>
			    <td align="left" valign="middle"><input name="url_custom_metdata_file" type="text" size="60" id="url_custom_metdata_file" value="<?php echo esc_attr($_POST['url_custom_metdata_file']);?>"/></td>
		  </tr>
			<tr>
				    <td align="right" valign="top" class="row-title">&nbsp;</td>
				    <td align="left" valign="top"><span class="small_text"><strong><?php esc_html_e( 'ONLY' , 'audio6-html5' );?></strong><i> <?php esc_html_e( 'in the case you do not have a standard radio stream and you know the direct url to the metadata file' , 'audio6-html5' );?></i></td>
			</tr>
			<tr>
		    <td align="right" valign="top" class="row-title"><?php esc_html_e( 'Metadata File Type ( OPTIONAL )' , 'audio6-html5' );?></td>
		    <td align="left" valign="middle"><select name="metadata_file_type" id="metadata_file_type">
		      <option value="" <?php echo (($_POST['metadata_file_type']=='')?'selected="selected"':'')?>>default</option>
		      <option value="1" <?php echo (($_POST['metadata_file_type']=='1')?'selected="selected"':'')?>>stats?sid=1</option>
					<option value="2" <?php echo (($_POST['metadata_file_type']=='2')?'selected="selected"':'')?>>7.html</option>
					<option value="3" <?php echo (($_POST['metadata_file_type']=='3')?'selected="selected"':'')?>>status-json.xsl</option>
					<option value="4" <?php echo (($_POST['metadata_file_type']=='4')?'selected="selected"':'')?>>status.xsl</option>
            </select></td>
	      </tr>
				<tr>
					    <td align="right" valign="top" class="row-title">&nbsp;</td>
					    <td align="left" valign="top"><span class="small_text"><strong><?php esc_html_e( 'ONLY' , 'audio6-html5' );?></strong><i> <?php esc_html_e( 'in the case you do not have a standard radio stream and you know the direct url to the metadata file' , 'audio6-html5' );?></i></td>
				</tr>
				<tr>
					<td align="right" valign="top" colspan="2"><hr></hr></td>
				</tr>
			<tr>
			    <td align="right" valign="top" class="row-title"><?php esc_html_e( 'The MSCP PRO json Api URL ( OPTIONAL )' , 'audio6-html5' );?></td>
			    <td align="left" valign="middle"><input name="mscp_pro_api_url" type="text" size="60" id="mscp_pro_api_url" value="<?php echo esc_attr($_POST['mscp_pro_api_url']);?>"/></td>
		  </tr>
			<tr>
				    <td align="right" valign="top" class="row-title">&nbsp;</td>
				    <td align="left" valign="top"><span class="small_text"><strong><?php esc_html_e( 'ONLY' , 'audio6-html5' );?></strong><i> <?php esc_html_e( 'in the case you are using a MSCP PRO radio server. This url will be used if you want to display the cover image from MSCP PRO radio server.' , 'audio6-html5' );?></i></td>
			</tr>
			<tr>
				<td align="right" valign="top" colspan="2"><hr></hr></td>
			</tr>
		  <tr>
		    <td align="right" valign="top" class="row-title"><?php esc_html_e( 'Skin Name' , 'audio6-html5' );?></td>
		    <td align="left" valign="middle"><select name="skin" id="skin">
		      <option value="whiteControllers" <?php echo (($_POST['skin']=='whiteControllers')?'selected="selected"':'')?>>whiteControllers</option>
		      <option value="blackControllers" <?php echo (($_POST['skin']=='blackControllers')?'selected="selected"':'')?>>blackControllers</option>
            </select></td>
	      </tr>

		  <tr>
		    <td align="right" valign="top" class="row-title"><?php esc_html_e( 'Player Width' , 'audio6-html5' );?></td>
		    <td align="left" valign="middle"><input name="playerWidth" type="text" size="25" id="playerWidth" value="<?php echo esc_attr($_POST['playerWidth']);?>"/></td>
	      </tr>
		  <tr>
		    <td align="right" valign="top" class="row-title"><?php esc_html_e( 'Image Height' , 'audio6-html5' );?></td>
		    <td align="left" valign="middle"><input name="imageHeight" type="text" size="25" id="imageHeight" value="<?php echo esc_attr($_POST['imageHeight']);?>"/></td>
	      </tr>
		  <tr>
		    <td align="right" valign="top" class="row-title"><?php esc_html_e( 'Responsive' , 'audio6-html5' );?></td>
		    <td align="left" valign="middle"><select name="responsive" id="responsive">
		      <option value="true" <?php echo (($_POST['responsive']=='true')?'selected="selected"':'')?>>true</option>
		      <option value="false" <?php echo (($_POST['responsive']=='false')?'selected="selected"':'')?>>false</option>
		      </select></td>
	   </tr>
		<tr>
		    <td align="right" valign="top" class="row-title"><?php esc_html_e( 'Auto Play' , 'audio6-html5' );?></td>
		    <td align="left" valign="middle"><select name="autoPlay" id="autoPlay">
              <option value="true" <?php echo (($_POST['autoPlay']=='true')?'selected="selected"':'')?>>true</option>
              <option value="false" <?php echo (($_POST['autoPlay']=='false')?'selected="selected"':'')?>>false</option>
            </select></td>
	    </tr>
		<tr>
		    <td align="right" valign="top" class="row-title"><?php esc_html_e( 'Center Player' , 'audio6-html5' );?></td>
		    <td align="left" valign="middle"><select name="centerPlayer" id="centerPlayer">
              <option value="true" <?php echo (($_POST['centerPlayer']=='true')?'selected="selected"':'')?>>true</option>
              <option value="false" <?php echo (($_POST['centerPlayer']=='false')?'selected="selected"':'')?>>false</option>
            </select></td>
	    </tr>
		  <tr>
		    <td align="right" valign="top" class="row-title"><?php esc_html_e( 'Default "No Image Available"' , 'audio6-html5' );?></td>
		    <td align="left" valign="top"><input name="noImageAvailable" type="text" id="noImageAvailable" size="80" value="<?php echo esc_attr($_POST['noImageAvailable'])?>" /> <input name="upload_noImageAvailable_button" type="button" id="upload_noImageAvailable_button" value="Change Image" />
		      <br />
		      <?php esc_html_e( 'Enter an URL or upload an image' , 'audio6-html5' );?><br />
              <div id="noImageAvailable_preview_div" class="lbg_left_p0"> <img src="<?php echo esc_url($_POST['noImageAvailable'])?>" alt="" name="noImageAvailable_preview" id="noImageAvailable_preview" /> </div></td>
	      </tr>
	      <tr>
		    <td align="right" valign="top" class="row-title"><?php esc_html_e( 'Sticky' , 'audio6-html5' );?></td>
		    <td align="left" valign="middle"><select name="sticky" id="sticky">
              <option value="true" <?php echo (($_POST['sticky']=='true')?'selected="selected"':'')?>>true</option>
              <option value="false" <?php echo (($_POST['sticky']=='false')?'selected="selected"':'')?>>false</option>
            </select></td>
	   </tr>
           <tr>
                <td align="right" valign="top" class="row-title"><?php esc_html_e( 'Activate For Footer (it needs Sticky set to true)' , 'audio6-html5' );?></td>
                <td align="left" valign="middle"><select name="activateForFooter" id="activateForFooter">
                  <option value="true" <?php echo (($_POST['activateForFooter']=='true')?'selected="selected"':'')?>>true</option>
                  <option value="false" <?php echo (($_POST['activateForFooter']=='false')?'selected="selected"':'')?>>false</option>
                </select></td>
           </tr>
           <tr>
		    <td align="right" valign="top" class="row-title"><?php esc_html_e( 'Start Minified (it needs Sticky set to true)' , 'audio6-html5' );?></td>
		    <td align="left" valign="middle"><select name="startMinified" id="startMinified">
              <option value="true" <?php echo (($_POST['startMinified']=='true')?'selected="selected"':'')?>>true</option>
              <option value="false" <?php echo (($_POST['startMinified']=='false')?'selected="selected"':'')?>>false</option>
            </select></td>
	   </tr>
           <tr>
		    <td align="right" valign="top" class="row-title"><?php esc_html_e( 'Show Only Play Button' , 'audio6-html5' );?></td>
		    <td align="left" valign="middle"><select name="showOnlyPlayButton" id="showOnlyPlayButton">
              <option value="true" <?php echo (($_POST['showOnlyPlayButton']=='true')?'selected="selected"':'')?>>true</option>
              <option value="false" <?php echo (($_POST['showOnlyPlayButton']=='false')?'selected="selected"':'')?>>false</option>
            </select></td>
	   </tr>
		  <tr>
		    <td align="right" valign="top" class="row-title"><?php esc_html_e( 'Grab Artist Photo' , 'audio6-html5' );?></td>
		    <td align="left" valign="middle"><select name="grabLastFmPhoto" id="grabLastFmPhoto">
              <option value="true" <?php echo (($_POST['grabLastFmPhoto']=='true')?'selected="selected"':'')?>>true</option>
              <option value="false" <?php echo (($_POST['grabLastFmPhoto']=='false')?'selected="selected"':'')?>>false</option>
            </select></td>
	    </tr>
		  <tr>
		    <td align="right" valign="top" class="row-title"><?php esc_html_e( 'Show Volume' , 'audio6-html5' );?></td>
		    <td align="left" valign="middle"><select name="showVolume" id="showVolume">
              <option value="true" <?php echo (($_POST['showVolume']=='true')?'selected="selected"':'')?>>true</option>
              <option value="false" <?php echo (($_POST['showVolume']=='false')?'selected="selected"':'')?>>false</option>
            </select></td>
	   </tr>

		 <tr>
		    <td align="right" valign="top" class="row-title"><?php esc_html_e( 'Show Song Title &amp; Author' , 'audio6-html5' );?></td>
		    <td align="left" valign="middle"><select name="showTitle" id="showTitle">
              <option value="true" <?php echo (($_POST['showTitle']=='true')?'selected="selected"':'')?>>true</option>
              <option value="false" <?php echo (($_POST['showTitle']=='false')?'selected="selected"':'')?>>false</option>
            </select></td>
	   </tr>
		  <tr>
		    <td align="right" valign="top" class="row-title"><?php esc_html_e( 'Song Title - Text Color' , 'audio6-html5' );?></td>
		    <td align="left" valign="middle"><input name="songTitleColor" type="text" size="25" id="songTitleColor" value="<?php echo esc_attr($_POST['songTitleColor']);?>" style="background-color:#<?php echo esc_attr($_POST['songTitleColor']);?>" />
            <script>
jQuery('#songTitleColor').ColorPicker({
	onSubmit: function(hsb, hex, rgb, el) {
		jQuery(el).val(hex);
		jQuery(el).css("background-color",'#'+hex);
		jQuery(el).ColorPickerHide();
	},
	onBeforeShow: function () {
		jQuery(this).ColorPickerSetColor(this.value);
	}
})
.on('keyup', function(){
	jQuery(this).ColorPickerSetColor(this.value);
});
              </script>            </td>
	      </tr>

			<tr>
		    <td align="right" valign="top" class="row-title"><?php esc_html_e( 'Author Title - Text Color' , 'audio6-html5' );?></td>
		    <td align="left" valign="middle"><input name="authorTitleColor" type="text" size="25" id="authorTitleColor" value="<?php echo esc_attr($_POST['authorTitleColor']);?>" style="background-color:#<?php echo esc_attr($_POST['authorTitleColor']);?>" />
            <script>
jQuery('#authorTitleColor').ColorPicker({
	onSubmit: function(hsb, hex, rgb, el) {
		jQuery(el).val(hex);
		jQuery(el).css("background-color",'#'+hex);
		jQuery(el).ColorPickerHide();
	},
	onBeforeShow: function () {
		jQuery(this).ColorPickerSetColor(this.value);
	}
})
.on('keyup', function(){
	jQuery(this).ColorPickerSetColor(this.value);
});
              </script>            </td>
	      </tr>
<tr>
		    <td align="right" valign="top" class="row-title"><?php esc_html_e( 'Show Radio Station' , 'audio6-html5' );?></td>
		    <td align="left" valign="middle"><select name="showRadioStation" id="showRadioStation">
              <option value="true" <?php echo (($_POST['showRadioStation']=='true')?'selected="selected"':'')?>>true</option>
              <option value="false" <?php echo (($_POST['showRadioStation']=='false')?'selected="selected"':'')?>>false</option>
            </select></td>
	   </tr>
		  <tr>
		    <td align="right" valign="top" class="row-title"><?php esc_html_e( 'Radio Station - Text Color' , 'audio6-html5' );?></td>
		    <td align="left" valign="middle"><input name="radioStationColor" type="text" size="25" id="radioStationColor" value="<?php echo esc_attr($_POST['radioStationColor']);?>" style="background-color:#<?php echo esc_attr($_POST['radioStationColor']);?>" />
            <script>
jQuery('#radioStationColor').ColorPicker({
	onSubmit: function(hsb, hex, rgb, el) {
		jQuery(el).val(hex);
		jQuery(el).css("background-color",'#'+hex);
		jQuery(el).ColorPickerHide();
	},
	onBeforeShow: function () {
		jQuery(this).ColorPickerSetColor(this.value);
	}
})
.on('keyup', function(){
	jQuery(this).ColorPickerSetColor(this.value);
});
              </script>            </td>
	      </tr>
	      <tr>
		    <td align="right" valign="top" class="row-title"><?php esc_html_e( 'Line Separator Color (between Song Title & Song Author)' , 'audio6-html5' );?></td>
		    <td align="left" valign="middle"><input name="lineSeparatorColor" type="text" size="25" id="lineSeparatorColor" value="<?php echo esc_attr($_POST['lineSeparatorColor']);?>" style="background-color:#<?php echo esc_attr($_POST['lineSeparatorColor']);?>" />
            <script>
jQuery('#lineSeparatorColor').ColorPicker({
	onSubmit: function(hsb, hex, rgb, el) {
		jQuery(el).val(hex);
		jQuery(el).css("background-color",'#'+hex);
		jQuery(el).ColorPickerHide();
	},
	onBeforeShow: function () {
		jQuery(this).ColorPickerSetColor(this.value);
	}
})
.on('keyup', function(){
	jQuery(this).ColorPickerSetColor(this.value);
});
              </script>            </td>
	      </tr>

		  <tr>
		    <td align="right" valign="top" class="row-title"><?php esc_html_e( 'Background Color Beneath Song Title' , 'audio6-html5' );?></td>
		    <td align="left" valign="middle"><input name="frameBehindTextColor" type="text" size="25" id="frameBehindTextColor" value="<?php echo esc_attr($_POST['frameBehindTextColor']);?>" style="background-color:#<?php echo esc_attr($_POST['frameBehindTextColor']);?>" />
            <script>
jQuery('#frameBehindTextColor').ColorPicker({
	onSubmit: function(hsb, hex, rgb, el) {
		jQuery(el).val(hex);
		jQuery(el).css("background-color",'#'+hex);
		jQuery(el).ColorPickerHide();
	},
	onBeforeShow: function () {
		jQuery(this).ColorPickerSetColor(this.value);
	}
})
.on('keyup', function(){
	jQuery(this).ColorPickerSetColor(this.value);
});
              </script>            </td>
	      </tr>
		  <tr>
		    <td align="right" valign="top" class="row-title"><?php esc_html_e( 'Background Color Beneath Radio Station Title' , 'audio6-html5' );?></td>
		    <td align="left" valign="middle"><input name="frameBehindButtonsColor" type="text" size="25" id="frameBehindButtonsColor" value="<?php echo esc_attr($_POST['frameBehindButtonsColor']);?>" style="background-color:#<?php echo esc_attr($_POST['frameBehindButtonsColor']);?>" />
            <script>
jQuery('#frameBehindButtonsColor').ColorPicker({
	onSubmit: function(hsb, hex, rgb, el) {
		jQuery(el).val(hex);
		jQuery(el).css("background-color",'#'+hex);
		jQuery(el).ColorPickerHide();
	},
	onBeforeShow: function () {
		jQuery(this).ColorPickerSetColor(this.value);
	}
})
.on('keyup', function(){
	jQuery(this).ColorPickerSetColor(this.value);
});
              </script>            </td>
	      </tr>

           <tr>
                   <td align="right" valign="top" class="row-title"><?php esc_html_e( 'Player Border Size' , 'audio6-html5' );?></td>
                   <td align="left" valign="middle"><input name="playerBorderSize" type="text" size="25" id="playerBorderSize" value="<?php echo esc_attr($_POST['playerBorderSize']);?>"/></td>
          </tr>
           <tr>
             <td align="right" valign="top" class="row-title"><?php esc_html_e( 'Player Border Color' , 'audio6-html5' );?></td>
             <td align="left" valign="middle"><input name="playerBorderColor" type="text" size="25" id="playerBorderColor" value="<?php echo esc_attr($_POST['playerBorderColor']);?>" style="background-color:#<?php echo esc_attr($_POST['playerBorderColor']);?>" />
            <script>
jQuery('#playerBorderColor').ColorPicker({
	onSubmit: function(hsb, hex, rgb, el) {
		jQuery(el).val(hex);
		jQuery(el).css("background-color",'#'+hex);
		jQuery(el).ColorPickerHide();
	},
	onBeforeShow: function () {
		jQuery(this).ColorPickerSetColor(this.value);
	}
})
.on('keyup', function(){
	jQuery(this).ColorPickerSetColor(this.value);
});
              </script>            </td>
           </tr>

		  <tr>
		    <td align="right" valign="top" class="row-title"><?php esc_html_e( 'Refresh Interval for Now-Playing Info' , 'audio6-html5' );?></td>
		    <td align="left" valign="middle"><input name="nowPlayingInterval" type="text" size="25" id="nowPlayingInterval" value="<?php echo esc_attr($_POST['nowPlayingInterval']);?>"/> seconds</td>
	      </tr>
			<tr>
		    <td align="right" valign="top" class="row-title"><?php esc_html_e( 'Player Loading Delay' , 'audio6-html5' );?></td>
		    <td align="left" valign="middle"><input name="delay" type="text" size="25" id="delay" value="<?php echo esc_attr($_POST['delay']);?>"/> seconds</td>
	      </tr>
		  <tr>
		    <td align="right" valign="top" class="row-title"><?php esc_html_e( 'Use The Original Upper&LowerCase for Song & Author As It Is In the Radio Metadata file' , 'audio6-html5' );?></td>
				<td align="left" valign="middle"><select name="preserveOriginalUpperLowerCase" id="preserveOriginalUpperLowerCase">
 		     <option value="true" <?php echo (($_POST['preserveOriginalUpperLowerCase']=='true')?'selected="selected"':'')?>>true</option>
 		     <option value="false" <?php echo (($_POST['preserveOriginalUpperLowerCase']=='false')?'selected="selected"':'')?>>false</option>
 		     </select></td>
	      </tr>
		 <tr>
		   <td align="right" valign="top" class="row-title"><?php esc_html_e( 'Show Twitter Button' , 'audio6-html5' );?></td>
		   <td align="left" valign="middle"><select name="showTwitterBut" id="showTwitterBut">
		     <option value="true" <?php echo (($_POST['showTwitterBut']=='true')?'selected="selected"':'')?>>true</option>
		     <option value="false" <?php echo (($_POST['showTwitterBut']=='false')?'selected="selected"':'')?>>false</option>
		     </select></td>
	      </tr>


		 <tr>
		    <td align="right" valign="top" class="row-title"><?php esc_html_e( 'Show FaceBook Button' , 'audio6-html5' );?></td>
		    <td align="left" valign="middle"><select name="showFacebookBut" id="showFacebookBut">
              <option value="true" <?php echo (($_POST['showFacebookBut']=='true')?'selected="selected"':'')?>>true</option>
              <option value="false" <?php echo (($_POST['showFacebookBut']=='false')?'selected="selected"':'')?>>false</option>
            </select></td>
	   </tr>
		 <tr>
		   <td align="right" valign="top" class="row-title"><?php esc_html_e( 'FaceBook AppID' , 'audio6-html5' );?></td>
		   <td align="left" valign="middle"><input name="facebookAppID" type="text" size="25" id="facebookAppID" value="<?php echo esc_attr($_POST['facebookAppID']);?>"/></td>
	      </tr>
		 <tr>
		   <td align="right" valign="top" class="row-title"><?php esc_html_e( 'FaceBook Share Title' , 'audio6-html5' );?></td>
		   <td align="left" valign="middle"><input name="facebookShareTitle" type="text" size="45" id="facebookShareTitle" value="<?php echo esc_attr($_POST['facebookShareTitle']);?>"/></td>
	      </tr>
		 <tr>
		   <td align="right" valign="top" class="row-title"><?php esc_html_e( 'FaceBook Share Description' , 'audio6-html5' );?></td>
		   <td align="left" valign="middle"><textarea name="facebookShareDescription" id="facebookShareDescription" cols="45" rows="5"><?php echo esc_textarea($_POST['facebookShareDescription']);?></textarea></td>
	     </tr>
		 <tr>
		    <td align="right" valign="top" class="row-title"><?php esc_html_e( 'FaceBook Share Image' , 'audio6-html5' );?></td>
		    <td align="left" valign="top"><input name="facebookShareImage" type="text" id="facebookShareImage" size="80" value="<?php echo esc_attr($_POST['facebookShareImage'])?>" /> <input name="upload_facebookShareImage_button" type="button" id="upload_facebookShareImage_button" value="Change Image" />
		      <br />
		      <?php esc_html_e( 'Enter an URL or upload an image' , 'audio6-html5' );?><br />
            <div id="facebookShareImage_preview_div" class="lbg_left_p0"> <img src="<?php echo esc_url($_POST['facebookShareImage'])?>" alt="" name="facebookShareImage_preview" id="facebookShareImage_preview" /> </div></td>
	   </tr>
		 <tr>
		 	<td align="right" valign="top" class="row-title"><?php esc_html_e( 'Check IceCast Metadata File First' , 'audio6-html5' );?></td>
		 	<td align="left" valign="middle"><select name="iceCastFirst" id="iceCastFirst">
		 		<option value="true" <?php echo (($_POST['iceCastFirst']=='true')?'selected="selected"':'')?>>true</option>
		 		<option value="false" <?php echo (($_POST['iceCastFirst']=='false')?'selected="selected"':'')?>>false</option>
		 		</select></td>
		 </tr>
		 <tr>
		 		<td align="right" valign="top" class="row-title"><?php esc_html_e( 'Path to the artist images/album covers folder ( OPTIONAL )' , 'audio6-html5' );?></td>
		 		<td align="left" valign="middle"><input name="optional_images_path" type="text" size="60" id="optional_images_path" value="<?php echo esc_attr($_POST['optional_images_path']);?>"/></td>
		 </tr>
		 <tr>
		 			<td align="right" valign="top" class="row-title">&nbsp;</td>
		 			<td align="left" valign="top"><span class="small_text"><i>in the case you have your images stored on your server (the same as your website) and you want to use those images for the current playing song. The image name should be identical with the current playing song.
Example: Artist Name - Song Name.jpg</i></td>
		 </tr>
		 <tr>
			<td align="right" valign="top" class="row-title"><?php esc_html_e( 'Display the number of listeners' , 'audio6-html5' );?></td>
			<td align="left" valign="middle"><select name="showListeners" id="showListeners">
				<option value="true" <?php echo (($_POST['showListeners']=='true')?'selected="selected"':'')?>>true</option>
				<option value="false" <?php echo (($_POST['showListeners']=='false')?'selected="selected"':'')?>>false</option>
				</select></td>
		 </tr>
		 <tr>
				<td align="right" valign="top" class="row-title"><?php esc_html_e( 'Translate Listeners' , 'audio6-html5' );?></td>
				<td align="left" valign="middle"><input name="translateListeners" type="text" size="45" id="translateListeners" value="<?php echo esc_attr($_POST['translateListeners']);?>"/></td>
			</tr>

		 <tr>
		   <td align="right" valign="top" class="row-title">&nbsp;</td>
		   <td align="left" valign="middle">&nbsp;</td>
	      </tr>

      </table>
  </div>
  <h3><a href="#">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<?php esc_html_e( 'History Settings' , 'audio6-html5' );?></a></h3>
  <div class="lbg_pd30">
	  <table class="wp-list-table widefat fixed pages" cellspacing="0">
		 <tr>
		    <td align="right" valign="top" class="row-title" width="30%"><?php esc_html_e( 'Show History On Init' , 'audio6-html5' );?></td>
		    <td align="left" valign="middle" width="70%"><select name="showHistoryOnInit" id="showHistoryOnInit">
              <option value="true" <?php echo (($_POST['showHistoryOnInit']=='true')?'selected="selected"':'')?>>true</option>
              <option value="false" <?php echo (($_POST['showHistoryOnInit']=='false')?'selected="selected"':'')?>>false</option>
            </select></td>
	   </tr>
		 <tr>
		    <td align="right" valign="top" class="row-title"><?php esc_html_e( 'Show History Button' , 'audio6-html5' );?></td>
		    <td align="left" valign="middle"><select name="showHistoryBut" id="showHistoryBut">
              <option value="true" <?php echo (($_POST['showHistoryBut']=='true')?'selected="selected"':'')?>>true</option>
              <option value="false" <?php echo (($_POST['showHistoryBut']=='false')?'selected="selected"':'')?>>false</option>
            </select></td>
	   </tr>
		<tr>
		    <td align="right" valign="top" class="row-title"><?php esc_html_e( 'Show History' , 'audio6-html5' );?></td>
		    <td align="left" valign="middle"><select name="showHistory" id="showHistory">
              <option value="true" <?php echo (($_POST['showHistory']=='true')?'selected="selected"':'')?>>true</option>
              <option value="false" <?php echo (($_POST['showHistory']=='false')?'selected="selected"':'')?>>false</option>
            </select></td>
	   </tr>
          <tr>
             <td align="right" valign="top" class="row-title"><?php esc_html_e( 'Translate Reading Data' , 'audio6-html5' );?></td>
             <td align="left" valign="middle"><input name="translateReadingData" type="text" size="45" id="translateReadingData" value="<?php echo esc_attr($_POST['translateReadingData']);?>"/></td>
           </tr>
           <tr>
             <td align="right" valign="top" class="row-title"><?php esc_html_e( 'Translate History Title' , 'audio6-html5' );?></td>
             <td align="left" valign="middle"><input name="historyTranslate" type="text" size="45" id="historyTranslate" value="<?php echo esc_attr($_POST['historyTranslate']);?>"/></td>
           </tr>
          <tr>
             <td align="right" valign="top" class="row-title"><?php esc_html_e( 'History Title Color' , 'audio6-html5' );?></td>
             <td align="left" valign="middle"><input name="historyTitleColor" type="text" size="25" id="historyTitleColor" value="<?php echo esc_attr($_POST['historyTitleColor']);?>" style="background-color:#<?php echo esc_attr($_POST['historyTitleColor']);?>" />
            <script>
jQuery('#historyTitleColor').ColorPicker({
	onSubmit: function(hsb, hex, rgb, el) {
		jQuery(el).val(hex);
		jQuery(el).css("background-color",'#'+hex);
		jQuery(el).ColorPickerHide();
	},
	onBeforeShow: function () {
		jQuery(this).ColorPickerSetColor(this.value);
	}
})
.on('keyup', function(){
	jQuery(this).ColorPickerSetColor(this.value);
});
              </script>            </td>
          </tr>
          <tr>
		    <td align="right" valign="top" class="row-title"><?php esc_html_e( 'History Background Color' , 'audio6-html5' );?></td>
		    <td align="left" valign="middle"><input name="historyBgColor" type="text" size="25" id="historyBgColor" value="<?php echo esc_attr($_POST['historyBgColor']);?>" style="background-color:#<?php echo esc_attr($_POST['historyBgColor']);?>" />
            <script>
jQuery('#historyBgColor').ColorPicker({
	onSubmit: function(hsb, hex, rgb, el) {
		jQuery(el).val(hex);
		jQuery(el).css("background-color",'#'+hex);
		jQuery(el).ColorPickerHide();
	},
	onBeforeShow: function () {
		jQuery(this).ColorPickerSetColor(this.value);
	}
})
.on('keyup', function(){
	jQuery(this).ColorPickerSetColor(this.value);
});
              </script>            </td>
	      </tr>
		  <tr>
		    <td align="right" valign="top" class="row-title"><?php esc_html_e( 'History Record Background Color' , 'audio6-html5' );?></td>
		    <td align="left" valign="middle"><input name="historyRecordBgColor" type="text" size="25" id="historyRecordBgColor" value="<?php echo esc_attr($_POST['historyRecordBgColor']);?>" style="background-color:#<?php echo esc_attr($_POST['historyRecordBgColor']);?>" />
            <script>
jQuery('#historyRecordBgColor').ColorPicker({
	onSubmit: function(hsb, hex, rgb, el) {
		jQuery(el).val(hex);
		jQuery(el).css("background-color",'#'+hex);
		jQuery(el).ColorPickerHide();
	},
	onBeforeShow: function () {
		jQuery(this).ColorPickerSetColor(this.value);
	}
})
.on('keyup', function(){
	jQuery(this).ColorPickerSetColor(this.value);
});
              </script>            </td>
	      </tr>
		  <tr>
		    <td align="right" valign="top" class="row-title"><?php esc_html_e( 'History Record Bottom Border Color' , 'audio6-html5' );?></td>
		    <td align="left" valign="middle"><input name="historyRecordBottomBorderColor" type="text" size="25" id="historyRecordBottomBorderColor" value="<?php echo esc_attr($_POST['historyRecordBottomBorderColor']);?>" style="background-color:#<?php echo esc_attr($_POST['historyRecordBottomBorderColor']);?>" />
            <script>
jQuery('#historyRecordBottomBorderColor').ColorPicker({
	onSubmit: function(hsb, hex, rgb, el) {
		jQuery(el).val(hex);
		jQuery(el).css("background-color",'#'+hex);
		jQuery(el).ColorPickerHide();
	},
	onBeforeShow: function () {
		jQuery(this).ColorPickerSetColor(this.value);
	}
})
.on('keyup', function(){
	jQuery(this).ColorPickerSetColor(this.value);
});
              </script>            </td>
	      </tr>
		  <tr>
		    <td align="right" valign="top" class="row-title"><?php esc_html_e( 'History Record Song Color' , 'audio6-html5' );?></td>
		    <td align="left" valign="middle"><input name="historyRecordSongColor" type="text" size="25" id="historyRecordSongColor" value="<?php echo esc_attr($_POST['historyRecordSongColor']);?>" style="background-color:#<?php echo esc_attr($_POST['historyRecordSongColor']);?>" />
            <script>
jQuery('#historyRecordSongColor').ColorPicker({
	onSubmit: function(hsb, hex, rgb, el) {
		jQuery(el).val(hex);
		jQuery(el).css("background-color",'#'+hex);
		jQuery(el).ColorPickerHide();
	},
	onBeforeShow: function () {
		jQuery(this).ColorPickerSetColor(this.value);
	}
})
.on('keyup', function(){
	jQuery(this).ColorPickerSetColor(this.value);
});
              </script>            </td>
	      </tr>

		  <tr>
		    <td align="right" valign="top" class="row-title"><?php esc_html_e( 'History Record Title Limit' , 'audio6-html5' );?></td>
		    <td align="left" valign="middle"><input name="historyRecordTitleLimit" type="text" size="15" id="historyRecordTitleLimit" value="<?php echo esc_attr($_POST['historyRecordTitleLimit']);?>"/></td>
	      </tr>
		  <tr>
		    <td align="right" valign="top" class="row-title"><?php esc_html_e( 'History Record Song Bottom Border Color' , 'audio6-html5' );?></td>
		    <td align="left" valign="middle"><input name="historyRecordSongBottomBorderColor" type="text" size="25" id="historyRecordSongBottomBorderColor" value="<?php echo esc_attr($_POST['historyRecordSongBottomBorderColor']);?>" style="background-color:#<?php echo esc_attr($_POST['historyRecordSongBottomBorderColor']);?>" />
            <script>
jQuery('#historyRecordSongBottomBorderColor').ColorPicker({
	onSubmit: function(hsb, hex, rgb, el) {
		jQuery(el).val(hex);
		jQuery(el).css("background-color",'#'+hex);
		jQuery(el).ColorPickerHide();
	},
	onBeforeShow: function () {
		jQuery(this).ColorPickerSetColor(this.value);
	}
})
.on('keyup', function(){
	jQuery(this).ColorPickerSetColor(this.value);
});
              </script>            </td>
	      </tr>
		  <tr>
		    <td align="right" valign="top" class="row-title"><?php esc_html_e( 'History Record Author Color' , 'audio6-html5' );?></td>
		    <td align="left" valign="middle"><input name="historyRecordAuthorColor" type="text" size="25" id="historyRecordAuthorColor" value="<?php echo esc_attr($_POST['historyRecordAuthorColor']);?>" style="background-color:#<?php echo esc_attr($_POST['historyRecordAuthorColor']);?>" />
            <script>
jQuery('#historyRecordAuthorColor').ColorPicker({
	onSubmit: function(hsb, hex, rgb, el) {
		jQuery(el).val(hex);
		jQuery(el).css("background-color",'#'+hex);
		jQuery(el).ColorPickerHide();
	},
	onBeforeShow: function () {
		jQuery(this).ColorPickerSetColor(this.value);
	}
})
.on('keyup', function(){
	jQuery(this).ColorPickerSetColor(this.value);
});
              </script>            </td>
	      </tr>
		  <tr>
		    <td align="right" valign="top" class="row-title"><?php esc_html_e( 'History Record Author Limit' , 'audio6-html5' );?></td>
		    <td align="left" valign="middle"><input name="historyRecordAuthorLimit" type="text" size="15" id="historyRecordAuthorLimit" value="<?php echo esc_attr($_POST['historyRecordAuthorLimit']);?>"/></td>
	      </tr>
		  <tr>
		    <td align="right" valign="top" class="row-title"><?php esc_html_e( 'Number Of Items Per Screen' , 'audio6-html5' );?></td>
		    <td align="left" valign="top"><input name="numberOfThumbsPerScreen" type="text" size="25" id="numberOfThumbsPerScreen" value="<?php echo esc_attr($_POST['numberOfThumbsPerScreen']);?>"/></td>
	    </tr>
		  <tr>
		    <td align="right" valign="top" class="row-title"><?php esc_html_e( 'History Padding' , 'audio6-html5' );?></td>
		    <td align="left" valign="middle"><input name="historyPadding" type="text" size="25" id="historyPadding" value="<?php echo esc_attr($_POST['historyPadding']);?>"/></td>
	    </tr>
			<tr>
				<td align="right" valign="top" class="row-title"><?php esc_html_e( 'History Max Number of Songs' , 'audio6-html5' );?></td>
				<td align="left" valign="middle"><input name="historyMaxNumberOfSongs" type="text" size="15" id="historyMaxNumberOfSongs" value="<?php echo esc_attr($_POST['historyMaxNumberOfSongs']);?>"/></td>
			</tr>
		  <tr>
		    <td align="right" valign="top" class="row-title">&nbsp;</td>
		    <td align="left" valign="middle">&nbsp;</td>
	      </tr>


		  <tr>
		    <td align="right" valign="top" class="row-title">&nbsp;</td>
		    <td align="left" valign="middle">&nbsp;</td>
	      </tr>

      </table>
  </div>



</div>

<div class="lbg_cent_p"><input name="Submit" type="submit" id="Submit" class="button-primary" value="Update Player Settings"></div>

</form>
</div>
