<?php
/*
Plugin Name: CLEVER - HTML5 Radio Player With History - Addon For Visual Composer
Description: A Visual Composer Addon which will allow you to insert an advanced HTML5 Radio Player with history support
Version: 2.3
Author: Lambert Group
Author URI: https://1.envato.market/OZ5Zr
Text Domain: lbg-cleverbakery
*/

$clever_addon_rand_id=rand(10,999999);

if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}


function clever_addon_vc_map_dependencies() {
	if ( ! defined( 'WPB_VC_VERSION' ) ) {
		$plugin_data = get_plugin_data(__FILE__);
        echo '<div class="updated">
          <p>'.sprintf(__('<strong>%s</strong> requires <strong><a href="https://bit.ly/vcomposer" target="_blank">Visual Composer</a></strong> plugin to be installed and activated on your site.', 'lbg-cleverbakery'), $plugin_data['Name']).'</p>
        </div>';
	}
}
add_action( 'admin_notices', 'clever_addon_vc_map_dependencies' );


function clever_addon_vc_map_init() {
	//categories start
	global $wpdb;
	global $clever_addon_rand_id;



			//Create New Param Type 'clever_slider'
			//add_shortcode_param
			vc_add_shortcode_param( 'clever_slider', 'clever_slider_callback', plugins_url() . '/lbg_clever_addon_visual_composer/assets/new_param_type/clever_slider.js');
			function clever_slider_callback( $settings, $value ) {
				return '<div class="my_param_block">'
				.'<input id="' . esc_attr( $settings['param_name'] ) . '" name="' . esc_attr( $settings['param_name'] ) . '" class="wpb_vc_param_value wpb-textinput ' . esc_attr( $settings['param_name'] ) . ' ' .              esc_attr( $settings['type'] ) . '_field" type="text" value="' . esc_attr( $value ) . '" style="width:70%;" />'.'<div id="' . esc_attr( $settings['param_name'] ) . '-slider-range-min" style="width:200px; margin-top:10px;"></div>'.'</div>'; // This is html markup that will be outputted in content elements edit form
			}




	vc_map( array(
		'name' => __( 'Clever Radio Player', 'lbg-cleverbakery' ),
		'base' => 'clever',
		"icon" => plugins_url('assets/images/clever_icon.png', __FILE__), // or css class name which you can reffer in your css file later. Example: "vc_extend_my_class"
		"category" => __('LBG Multimedia Addons', 'lbg-cleverbakery' ),
		"description" => __("HTML5 Radio Player with history support", 'lbg-cleverbakery'), //vc_extend
		'show_settings_on_create' => true,
		'is_container' => true,
		'params' => array(
			array(
				'group' => 'General',
				'type' => 'textfield',
				'heading' => esc_html__( 'Calendar ID', 'lbg-cleverbakery' ),
				'param_name' => 'id',
				'value' => esc_html__( "".esc_attr($clever_addon_rand_id)."", "lbg-cleverbakery" ),
				'description' => esc_html__( "It is automaticaly generated and it has to be unique. You can leave it just like it is.", "lbg-cleverbakery" )
			),
			array(
				'group' => 'General',
				'type' => 'textfield',
				'heading' => esc_html__( 'Radio Stream Link', 'lbg-cleverbakery' ),
				'param_name' => 'radio_stream', //radio_stream
				'value' => esc_html__( "", "lbg-cleverbakery" ),
				'description' => esc_html__( "Shoutcast link structure: http://[ip]:[port]/; - Icecast link structure: http://[domain]:[port]/mountpoint", "lbg-cleverbakery" )
			),
			array(
				'group' => 'General',
				'type' => 'textfield',
				'heading' => esc_html__( 'Optional Shoutcast Sid', 'lbg-cleverbakery' ),
				'param_name' => 'optional_shoutcast_sid', //optional_shoutcast_sid
				'value' => esc_html__( "1", "lbg-cleverbakery" )
			),
			array(
				'group' => 'General',
				'type' => 'textfield',
				'heading' => esc_html__( 'Player Width', 'lbg-cleverbakery' ),
				'param_name' => 'playerwidth', //playerWidth
				'value' => esc_html__( "760", "lbg-cleverbakery" )
			),
			array(
				'group' => 'General',
				'type' => 'dropdown',
				'heading' => esc_html__( 'Player Width 100%', 'lbg-cleverbakery' ),
				'param_name' => 'width100proc', //width100Proc
				'value'       => array(
					'No'   => 'false',
					'Yes'   => 'true'
				 ),
				'description' => esc_html__( "The player will cover the entire parent div width", "lbg-cleverbakery" )
			),
			array(
				'group' => 'General',
				'type' => 'textfield',
				'heading' => esc_html__( 'Player Left Padding', 'lbg-cleverbakery' ),
				'param_name' => 'historyleftpadding', //historyLeftPadding
				'value' => esc_html__( "25", "lbg-cleverbakery" )
			),
			array(
				'group' => 'General',
				'type' => 'textfield',
				'heading' => esc_html__( 'Player Right Padding', 'lbg-cleverbakery' ),
				'param_name' => 'historyrightpadding', //historyRightPadding
				'value' => esc_html__( "25", "lbg-cleverbakery" )
			),
			array(
				'group' => 'General',
				'type' => 'textfield',
				'heading' => esc_html__( 'Player Top Padding', 'lbg-cleverbakery' ),
				'param_name' => 'historytoppadding', //historyTopPadding
				'value' => esc_html__( "30", "lbg-cleverbakery" )
			),
			array(
				'group' => 'General',
				'type' => 'textfield',
				'heading' => esc_html__( 'Player Bottom Padding', 'lbg-cleverbakery' ),
				'param_name' => 'historybottompadding', //historyBottomPadding
				'value' => esc_html__( "30", "lbg-cleverbakery" )
			),
			array(
				'group' => 'General',
				'type' => 'dropdown',
				'heading' => esc_html__( 'Center Player', 'lbg-cleverbakery' ),
				'param_name' => 'centerplayer', //centerPlayer
				'value'       => array(
					'Yes'   => 'true',
					'No'   => 'false'
				  )
			),
			array(
				'group' => 'General',
				'type' => 'dropdown',
				'heading' => esc_html__( 'Sticky', 'lbg-cleverbakery' ),
				'param_name' => 'sticky', //sticky
				'value'       => array(
					'No'   => 'false',
					'Yes'   => 'true'
				  )
			),
			array(
				'group' => 'General',
				'type' => 'dropdown',
				'heading' => esc_html__( 'Auto Play', 'lbg-cleverbakery' ),
				'param_name' => 'autoplay', //autoPlay
				'value'       => array(
					'No'   => 'false',
					'Yes'   => 'true'
				  )
			),
			array(
				'group' => 'General',
				'type' => 'attach_image',
				'heading' => esc_html__( 'Default "No Image Available"', 'lbg-cleverbakery' ),
				'param_name' => 'noimageavailable', //noImageAvailable
				'description' => esc_html__( 'Select an image from Media Library', 'lbg-cleverbakery' )
			),
			array(
				'group' => 'General',
				'type' => 'dropdown',
				'heading' => esc_html__( 'Grab Artist Photo', 'lbg-cleverbakery' ),
				'param_name' => 'grabartistphoto', //grabArtistPhoto
				'value'       => array(
					'Yes'   => 'true',
					'No'   => 'false'
					)
			),
			array(
				'group' => 'General',
				'type' => 'textfield',
				'heading' => esc_html__( 'Player Border Width', 'lbg-cleverbakery' ),
				'param_name' => 'borderwidth', //borderWidth
				'value' => esc_html__( "1", "lbg-cleverbakery" )
			),
			array(
				'group' => 'General',
				'type' => 'colorpicker',
				'heading' => esc_html__( "Player Border Color", "lbg-cleverbakery" ),
				'param_name' => 'bordercolor', //borderColor
				'value' => '#bfbfbf',
				'description' => esc_html__( "Choose the color", "lbg-cleverbakery" )
			),
			array(
				'group' => 'General',
				'type' => 'colorpicker',
				'heading' => esc_html__( "Player Background Color", "lbg-cleverbakery" ),
				'param_name' => 'bgcolor', //bgColor
				'value' => '#ffffff',
				'description' => esc_html__( "Choose the color", "lbg-cleverbakery" )
			),
			array(
				'group' => 'General',
				'type' => 'clever_slider',
				'heading' => esc_html__( 'Player Background Color Opacity/Alpha', 'lbg-cleverbakery' ),
				'param_name' => 'bgcoloropacity', //bgColorOpacity
				'value' => esc_html__( "100", "lbg-cleverbakery" ),
				'description' => esc_html__( "values between 0-100", "lbg-cleverbakery" )
			),
			array(
				'group' => 'General',
				'type' => 'textfield',
				'heading' => esc_html__( 'Total Number Of Elements Displayed (including the current playing one', 'lbg-cleverbakery' ),
				'param_name' => 'numberofelementsdisplayed', //numberOfElementsDisplayed
				'value' => esc_html__( "6", "lbg-cleverbakery" )
			),
			array(
				'group' => 'General',
				'type' => 'textfield',
				'heading' => esc_html__( 'Refresh Interval for Now-Playing Info', 'lbg-cleverbakery' ),
				'param_name' => 'nowplayinginterval', //nowPlayingInterval
				'value' => esc_html__( "35", "lbg-cleverbakery" )
			),
			array(
				'group' => 'General',
				'type' => 'textfield',
				'heading' => esc_html__( 'Player Loading Delay', 'lbg-cleverbakery' ),
				'param_name' => 'delay', //delay
				'value' => esc_html__( "1", "lbg-cleverbakery" )
			),
			array(
				'group' => 'General',
				'type' => 'colorpicker',
				'heading' => esc_html__( "Animated Bars Color", "lbg-cleverbakery" ),
				'param_name' => 'barscolor', //barsColor
				'value' => '#ffffff',
				'description' => esc_html__( "Choose the color", "lbg-cleverbakery" )
			),
			array(
				'group' => 'General',
				'type' => 'colorpicker',
				'heading' => esc_html__( "Play Button Color OFF State", "lbg-cleverbakery" ),
				'param_name' => 'playbuttoncolor', //playButtonColor
				'value' => '#ffffff',
				'description' => esc_html__( "Choose the color", "lbg-cleverbakery" )
			),
			array(
				'group' => 'General',
				'type' => 'colorpicker',
				'heading' => esc_html__( "Play Button Color ON State", "lbg-cleverbakery" ),
				'param_name' => 'playbuttonhovercolor', //playButtonHoverColor
				'value' => '#d7d7d7',
				'description' => esc_html__( "Choose the color", "lbg-cleverbakery" )
			),
			array(
				'group' => 'General',
				'type' => 'textfield',
				'heading' => esc_html__( 'Path to the artist images/album covers folder', 'lbg-cleverbakery' ),
				'param_name' => 'optional_images_path', //optional_images_path
				'value' => esc_html__( "", "lbg-cleverbakery" )
			),
			array(
				'group' => 'History',
				'type' => 'dropdown',
				'heading' => esc_html__( 'Use Radio Server Time', 'lbg-cleverbakery' ),
				'param_name' => 'useRadioServerTime', //useRadioServerTime
				'value'       => array(
					'No'   => 'false',
					'Yes'   => 'true'
				 ),
				'description' => esc_html__( "Yes - It will use for the history songs, the original time defined in ShoutCast history file; No - It will use for the history songs, the computer time.", "lbg-cleverbakery" )
			),
			array(
				'group' => 'History',
				'type' => 'colorpicker',
				'heading' => esc_html__( "History Record Time Color OFF State", "lbg-cleverbakery" ),
				'param_name' => 'historyrecordtimeoffcolor', //historyRecordTimeOffColor
				'value' => '#000000',
				'description' => esc_html__( "Choose the color", "lbg-cleverbakery" )
			),
			array(
				'group' => 'History',
				'type' => 'colorpicker',
				'heading' => esc_html__( "History Record Song Color OFF State", "lbg-cleverbakery" ),
				'param_name' => 'historyrecordsongoffcolor', //historyRecordSongOffColor
				'value' => '#000000',
				'description' => esc_html__( "Choose the color", "lbg-cleverbakery" )
			),
			array(
				'group' => 'History',
				'type' => 'colorpicker',
				'heading' => esc_html__( "History Record Author Color OFF State", "lbg-cleverbakery" ),
				'param_name' => 'historyrecordauthoroffcolor', //historyRecordAuthorOffColor
				'value' => '#575757',
				'description' => esc_html__( "Choose the color", "lbg-cleverbakery" )
			),
			array(
				'group' => 'History',
				'type' => 'colorpicker',
				'heading' => esc_html__( "Line Separator Color OFF State", "lbg-cleverbakery" ),
				'param_name' => 'songauthorlineseparatoroffcolor', //songAuthorLineSeparatorOffColor
				'value' => '#bfbfbf',
				'description' => esc_html__( "between Song Title & Song Author", "lbg-cleverbakery" )
			),
			array(
				'group' => 'History',
				'type' => 'colorpicker',
				'heading' => esc_html__( "History Record Background Color ON State", "lbg-cleverbakery" ),
				'param_name' => 'historyrecordbackgroundoncolor', //historyRecordBackgroundOnColor
				'value' => '#dd0060',
				'description' => esc_html__( "Choose the color", "lbg-cleverbakery" )
			),
			array(
				'group' => 'History',
				'type' => 'colorpicker',
				'heading' => esc_html__( "History Record Time Color ON State", "lbg-cleverbakery" ),
				'param_name' => 'historyrecordtimeoncolor', //historyRecordTimeOnColor
				'value' => '#FFFFFF',
				'description' => esc_html__( "Choose the color", "lbg-cleverbakery" )
			),
			array(
				'group' => 'History',
				'type' => 'colorpicker',
				'heading' => esc_html__( "History Record Song Color ON State", "lbg-cleverbakery" ),
				'param_name' => 'historyrecordsongoncolor', //historyRecordSongOnColor
				'value' => '#FFFFFF',
				'description' => esc_html__( "Choose the color", "lbg-cleverbakery" )
			),
			array(
				'group' => 'History',
				'type' => 'colorpicker',
				'heading' => esc_html__( "History Record Author Color ON State", "lbg-cleverbakery" ),
				'param_name' => 'historyrecordauthoroncolor', //historyRecordAuthorOnColor
				'value' => '#FFFFFF',
				'description' => esc_html__( "Choose the color", "lbg-cleverbakery" )
			),


					)
			) );
	}

add_action('vc_before_init', 'clever_addon_vc_map_init');



function clever_addon_enqueue_scripts_and_styles() {
		if (!is_admin()) { //loads js & css in front-end
		wp_enqueue_style('audio11-html5-site-css', plugins_url('audio11_html5_radio_history/audio11_html5.css', __FILE__));

		wp_enqueue_script('jquery');

			wp_enqueue_script('jquery-ui-core');
			wp_enqueue_script('jquery-ui-slider');
			wp_enqueue_script('jquery-effects-core');

		wp_register_script('lbg-audio11-html5', plugins_url('audio11_html5_radio_history/js/audio11_html5.js', __FILE__));
		wp_enqueue_script('lbg-audio11-html5');
	}
}
add_action( 'init', 'clever_addon_enqueue_scripts_and_styles' );


function clever_addon_enqueue_admin_scripts_and_styles() {
	//load scripts in admin
	wp_enqueue_style('lbg-vc-jquery-ui-custom_css', plugins_url('assets/jquery-ui.css', __FILE__));

	wp_enqueue_script('jquery-ui-slider');
}
add_action( 'admin_enqueue_scripts', 'clever_addon_enqueue_admin_scripts_and_styles' );



if (!function_exists('clever_addon_unstrip_array')) {
	//stripslashes for an entire array
	function clever_addon_unstrip_array($array){
		if (is_array($array)) {
			foreach($array as &$val){
				if(is_array($val)){
					$val = unstrip_array($val);
				} else {
					$val = stripslashes($val);

				}
			}
		}
		return $array;
	}
}




//the shortcodes
add_shortcode( 'clever', 'clever_func' );
	function clever_func( $atts, $content = null ) { // New function parameter $content is added!
		global $clever_addon_rand_id;

		$the_noimageavailable = array('');
		if ( array_key_exists('noimageavailable', $atts) && $atts["noimageavailable"]!='' ) {
				$the_noimageavailable=wp_get_attachment_image_src($atts["noimageavailable"], "large");
		}
		$path_to_plugin = plugin_dir_url(__FILE__);
		$pathToAjaxFiles_aux=$path_to_plugin.'audio11_html5_radio_history/';

		$initial_vals_arr=array(
			'id' => $clever_addon_rand_id,
			'playerwidth' => '760',
			'width100proc' => 'false',
			'radio_stream' => 'http://stream.rockradio.si:9034/;',
			'optional_shoutcast_sid' => '1',
			'borderwidth' => '1',
			'autoplay' => 'true',
			'bordercolor' => '#bfbfbf',
			'bgcolor' => '#ffffff',
			'bgcoloropacity' => '100',
			'barscolor' => '#ffffff',
			'playbuttoncolor' => '#ffffff',
			'playbuttonhovercolor' => '#d7d7d7',
			'optional_images_path' => '',
			'centerplayer' => 'true',
			'nowplayinginterval' => '35',
			'delay' => '1',
			'grabartistphoto' => 'true',
			'noimageavailable' => $the_noimageavailable,
			'sticky' => 'false',
			'activateforfooter' => 'false',
			'numberofelementsdisplayed' => '6',
			'historyleftpadding' => '25',
			'historyrightpadding' => '25',
			'historytoppadding' => '30',
			'historybottompadding' => '30',
			'historyrecordtitlelimit' => '24',
			'historyrecordauthorlimit' => '34',
			'songauthorlineseparatoroffcolor' => 'bfbfbf',
			'historyrecordtimeoffcolor' => '#000000',
			'historyrecordsongoffcolor' => '#000000',
			'historyrecordauthoroffcolor' => '575757',
			'songauthorlineseparatoroncolor' => 'transparent',
			'historyrecordtimeoncolor' => '#FFFFFF',
			'historyrecordsongoncolor' => '#FFFFFF',
			'historyrecordauthoroncolor' => '#FFFFFF',
			'historyrecordbackgroundoncolor' => '#dd0060',
			'useradioservertime' => 'false'
		);

	   extract( shortcode_atts( $initial_vals_arr, $atts ) );
	   foreach ($initial_vals_arr as $key => $value) {
			if (!isset($atts[$key])) {
				$atts[$key]=$value;
			}
		}

	$aux_content='';

	$aux_content.='<script>
		jQuery(function() {
setTimeout(function(){
			jQuery("#lbg_audio11_html5_shoutcast_'.$atts["id"].'").audio11_html5({
				radio_stream:"'.$atts["radio_stream"].'",
				optional_shoutcast_sid:'.$atts["optional_shoutcast_sid"].',
				playerWidth:'.$atts["playerwidth"].',
				width100Proc:'.$atts["width100proc"].',
				sticky:'.$atts["sticky"].',
				centerPlayer:'.$atts["centerplayer"].',
				grabArtistPhoto:'.$atts["grabartistphoto"].',
				autoPlay:'.$atts["autoplay"].',
				borderWidth:'.$atts["borderwidth"].',
				borderColor:"'.$atts["bordercolor"].'",
				bgColor:"'.$atts["bgcolor"].'",
				bgColorOpacity:'.($atts["bgcoloropacity"]/100).',
				barsColor:"'.$atts["barscolor"].'",
				playButtonColor:"'.$atts["playbuttoncolor"].'",
				playButtonHoverColor:"'.$atts["playbuttonhovercolor"].'",
				optional_images_path:"'.$atts["optional_images_path"].'",
				numberOfElementsDisplayed:'.$atts["numberofelementsdisplayed"].',
				useRadioServerTime:'.$atts["useradioservertime"].',
				historyLeftPadding:'.$atts["historyleftpadding"].',
				historyRightPadding:'.$atts["historyrightpadding"].',
				historyTopPadding:'.$atts["historytoppadding"].',
				historyBottomPadding:'.$atts["historybottompadding"].',
				historyRecordTitleLimit:'.$atts["historyrecordtitlelimit"].',
				historyRecordAuthorLimit:'.$atts["historyrecordauthorlimit"].',
				songAuthorLineSeparatorOffColor:"'.$atts["songauthorlineseparatoroffcolor"].'",
				historyRecordTimeOffColor:"'.$atts["historyrecordtimeoffcolor"].'",
				historyRecordSongOffColor:"'.$atts["historyrecordsongoffcolor"].'",
				historyRecordAuthorOffColor:"'.$atts["historyrecordauthoroffcolor"].'",
				songAuthorLineSeparatorOnColor:"'.$atts["songauthorlineseparatoroncolor"].'",
				historyRecordTimeOnColor:"'.$atts["historyrecordtimeoncolor"].'",
				historyRecordSongOnColor:"'.$atts["historyrecordsongoncolor"].'",
				historyRecordAuthorOnColor:"'.$atts["historyrecordauthoroncolor"].'",
				historyRecordBackgroundOnColor:"'.$atts["historyrecordbackgroundoncolor"].'",
				pathToAjaxFiles:"'.$pathToAjaxFiles_aux.'",
				nowPlayingInterval:'.$atts["nowplayinginterval"].',
				noImageAvailable:"'.$the_noimageavailable[0].'"
			});

}, '.($atts["delay"]*1000).');
		});
	</script>
    <div class="audio11_html5">
            <div id="lbg_audio11_html5_shoutcast_'.$atts["id"].'"></div>
     </div>
		 <br style="clear:both;">';

	return str_replace("\r\n", '', $aux_content);

	}

?>
